B $! SUBMIT_SINGLELINEJOB.COM-Submit a Single Line Job for Execution $!& $! Author:  Robert Gezelter, Principal/ $!          Robert Gezelter Software Consultant . $!          http://www.rlgsc.com, 3-March-2010 $!7 $! Copyright 2010, Robert Gezelter, All Rights Reserved  $!T $! Permission is granted worldwide to use, redistribute, and modify this procedure, C $! PROVIDED that the notices of original authorship are maintained.  $! $! $! Modified by:  $! $!N $! Extract the parameters from the command line. This code also checks to see F $! if the first parameter is a set of switches. This is somewhat more K $! restrictive than what is allowed in normal DCL commands, but the parsing J $! code written in DCL is more laborious than than provided as part of theK $! standard libraries that are called when an actual DCL command is parsed. N $! Per the limitations documented on the invocation of indirect command files,) $! the qualifiers must be quoted, to wit:  $!A $!   "o  If the first parameter begins with a slash (/), you must 9 $!       enclose the parameter in quotation marks (" ")." B $!                                    from OpenVMS HELP Text, V6.2 $!J $! The requirement that the qualifiers for the command be specified first N $! avoids the same ambiguity problem as with the conventional SPAWN commmand.  $!  Q $! There is a second restriction on this version of the implementation, which may O $! be relaxed in a future revision. If the actual first (non-parameter) string  L $! passed to the future process is a filename rather than a DCL command, theK $! symbol definition of that equivalence, and any logical names used in the & $! resulting expansion must be either: $!N $! - defined by the LOGIN profiles associated with the /USER specified (or the. $!   current user if the qualifier is omitted.J $! - any filenames must be resolveable using logical names defined in the G $!   context of a normal BATCH login (e.g., after the execution of the   $!   various login profiles) $! $	COMMAND = P1 $	COMMAND_PARAMETER_P1 = P2  $	COMMAND_PARAMETER_P2 = P3  $	COMMAND_PARAMETER_P3 = P4  $	COMMAND_PARAMETER_P4 = P5  $	COMMAND_PARAMETER_P5 = P6  $	COMMAND_PARAMETER_P6 = P7  $	COMMAND_QUALIFIERS = "" ( $	IF  F$EXTRACT(0, 1, COMMAND) .EQS. "/"* $	    THEN	! There are qualifiers supplied $		COMMAND_QUALIFIERS = P1 $		COMMAND = P2  $		COMMAND_PARAMETER_P1 = P3 $		COMMAND_PARAMETER_P2 = P4 $		COMMAND_PARAMETER_P3 = P5 $		COMMAND_PARAMETER_P4 = P6 $		COMMAND_PARAMETER_P5 = P7 $		COMMAND_PARAMETER_P6 = P8 $		ENDIF $!C $! Initialize the list of qualifiers, and the name of the log file. * $	VALID_QUALIFIERS = "/AF/LO/NA/PR/QU/US/"B $	VALID_FULL_QUALIFIERS = "/AFTER/LOG_FILE/NAME/PRINT/QUEUE/USER/" $	DCL_QUALIFIERS = ""  $	QUALIFIER_COUNT = 1  $	LOGFILE_NAME = ""  $	LOGFILE_DEFAULTNAME = ""B $	IF  F$LENGTH(COMMAND_QUALIFIERS) .EQ. 0 THEN GOTO EXECUTE_SUBMIT $!N $! If the first parameter contains a list of qualifiers, parse the list. SinceP $! the validity of the options will also be checked when the SUBMIT is executed,O $! this parsing is limited to separating the various elements (e.g., qualifiers O $! and values) so that the SUBMIT command can be constructed. All decisions are N $! deferred to the actual normal validation processing done as part of SUBMIT. $ NEXT_QUALIFIER:  $	NEGATED_QUALIFIER = 0 F $	QUALIFIER_TERM = F$ELEMENT(QUALIFIER_COUNT, "/", COMMAND_QUALIFIERS)7 $	IF  QUALIFIER_TERM .EQS. "/" THEN GOTO EXECUTE_SUBMIT F $	QUALIFIER_VERB = F$EDIT(F$ELEMENT(0, "=", QUALIFIER_TERM), "UPCASE")9 $	QUALIFIER_PARAMETER = F$ELEMENT(1, "=", QUALIFIER_TERM) A $	IF  QUALIFIER_PARAMETER .EQS. "=" THEN QUALIFIER_PARAMETER = "" 1 $	IF  F$EXTRACT(0, 2, QUALIFIER_VERB) .EQS. "NO"   $	    THEN   $		NEGATED_QUALIFIER = 1L $		QUALIFIER_VERB = F$EXTRACT(2, F$LENGTH(QUALIFIER_VERB)-2, QUALIFIER_VERB) $		ENDIF $!g $	IF  (F$LOCATE("/"+F$EXTRACT(0, 2, QUALIFIER_VERB), VALID_QUALIFIERS) .EQ. F$LENGTH(VALID_QUALIFIERS)) 
 $	    THEN( $		EXIT  229952 	! Exit with CLI$_IVQUAL $		ENDIF $!N $! Since the first two characters of the supported qualifiers are unambiguous,H $! the remainder of the each qualifier can also be validated as a stringI $! containing no characters inconsistent with the fully spelled qualifier N $! (e.g., "LO", "LOG", "LOG_FILE", and "LOG_F" are all permissible; "LOGFILE"  $! will not be accepted). ` $	IF  (F$LOCATE("/"+QUALIFIER_VERB, VALID_FULL_QUALIFIERS) .EQ. F$LENGTH(VALID_FULL_QUALIFIERS))
 $	    THEN& $		EXIT 229952	! Exit with CLI$_IVQUAL $		ENDIF $!I $! Use the first two characters in each qualifier as the index term in a  M $! DCL Computed GOTO (see http://www.rlgsc.com/demonstrations/dcl_goto.html). M $! Range checking is not needed, as the qualifier has already been validated. 1 $	GOSUB PROCESS_'F$EXTRACT(0, 2, QUALIFIER_VERB)' ' $	QUALIFIER_COUNT = QUALIFIER_COUNT + 1  $	GOTO NEXT_QUALIFIER  $!K $! Compute the name for the logfile and actually invoke SUBMIT. Report the  : $! results of the SUBMIT to our caller (success, failure). $ EXECUTE_SUBMIT: L $	COMMANDFILE_DIRECTORY = F$PARSE(F$ENVIRONMENT("PROCEDURE"),,,"DEVICE") + -6 	    F$PARSE(F$ENVIRONMENT("PROCEDURE"),,,"DIRECTORY")V $	LOGFILE_FULLNAME = F$PARSE(LOGFILE_NAME, LOGFILE_DEFAULTNAME, "[]SINGLELINEJOB.LOG")& $	SUBMIT /LOG_FILE='LOGFILE_FULLNAME'- 'DCL_QUALIFIERS'- - /PARAMETER=("''F$ENVIRONMENT(""DEFAULT"")", -  "''COMMAND'",- "''COMMAND_PARAMETER_P1'",-  "''COMMAND_PARAMETER_P2'",-  "''COMMAND_PARAMETER_P3'",-  "''COMMAND_PARAMETER_P4'",-  "''COMMAND_PARAMETER_P5'",-  "''COMMAND_PARAMETER_P6'"-6 )/NOPRINT 'COMMANDFILE_DIRECTORY'RUN_SINGLELINEJOB.COM $	EXIT $STATUS $!2 $! GOSUB Subroutines to process command qualifiers $! $ PROCESS_AF:  $	STRING = "AFTER"/ $	IF  NEGATED_QUALIFIER THEN STRING = "NOAFTER" G $	DCL_QUALIFIERS = DCL_QUALIFIERS + "/''STRING':" + QUALIFIER_PARAMETER  $	RETURN $!
 $ PROCESS_LO: ( $	IF  NEGATED_QUALIFIER THEN EXIT 229952$ $	LOGFILE_NAME = QUALIFIER_PARAMETER $	RETURN $! $ PROCESS_NA: ( $	IF  NEGATED_QUALIFIER THEN EXIT 229952K $	DCL_QUALIFIERS = DCL_QUALIFIERS + "/NAME:""" + QUALIFIER_PARAMETER + """" + $	LOGFILE_DEFAULTNAME = QUALIFIER_PARAMETER  $	RETURN $! $ PROCESS_PR:  $	IF  NEGATED_QUALIFIER 
 $	    THEN0 $			DCL_QUALIFIERS = DCL_QUALIFIERS + "/NOPRINT"
 $	    ELSE+ $		IF  F$LENGTH(QUALIFIER_PARAMETER) .GT. 0  $		    THEN N $			DCL_QUALIFIERS = DCL_QUALIFIERS + "/PRINT:""" + QUALIFIER_PARAMETER + """" $		    ELSE . $			DCL_QUALIFIERS = DCL_QUALIFIERS + "/PRINT"	 $			ENDIF  $		ENDIF $! $	RETURN $! $ PROCESS_QU: ( $	IF  NEGATED_QUALIFIER THEN EXIT 229952* $	IF  F$LENGTH(QUALIFIER_PARAMETER) .NE. 0
 $	    THEND $		DCL_QUALIFIERS = DCL_QUALIFIERS + "/QUEUE:" + QUALIFIER_PARAMETER $		ENDIF $	RETURN $!
 $ PROCESS_US: ( $	IF  NEGATED_QUALIFIER THEN EXIT 229952* $	IF  F$LENGTH(QUALIFIER_PARAMETER) .NE. 0
 $	    THENC $		DCL_QUALIFIERS = DCL_QUALIFIERS + "/USER:" + QUALIFIER_PARAMETER  $		ENDIF $	RETURN